# Housekeeper Agent Interaction Manual

## Overview

This manual is intended to assist the housekeeper agent in the successful execution of tasks within a simulated environment. The rules provide guidance on navigating, searching the environment, interacting with objects, and managing task-specific processes, as well as ensuring the correctness of actions using code assertions.

## Navigation and Search

### Introduction

These rules provide guidance on how to search for objects, including the use of helper methods to streamline the process and ensure thoroughness.

#### Included Rules

- **rule_0 (type="Special Mechanism")**: Objects can be found in unconventional locations, and the agent should **include all possible locations in its search**. For example, In epoch_9, the agent found a soapbar on the toilet, which is an unconventional location for storing such items.

- **rule_1 (type="Useful Helper Method")**: If there are multiple receptacles to be search, the agent can write and use 'find_object' method as shown in the example. For example, 

  ```python
  # Define helper method to find object that is needed
  def find_object(agent, recep_to_check, object_name):
    for receptacle in recep_to_check:
        observation = agent.go_to(receptacle)
        # Check if we need to open the receptacle. If we do, open it.
        if 'closed' in observation:
            observation = agent.open(receptacle)
        # Check if the object is in/on the receptacle.
        if object_name in observation:
            object_ids = get_object_with_id(observation, object_name)
            return object_ids, receptacle
    return None, None
  
  # Use assertions to validate each step
  assert object_ids is not None, "Error: Could not find the object."
  ```

## Object Interaction and Location Management

### Introduction

These rules inform the agent on how to interact with objects, from taking and placing items to handling multiple items of the same type. Proper location management is crucial for successful task execution.

#### Included Rules

- **rule_2 (type="Special Phenomena")**: When using a microwave, the agent can interact with it (e.g., heat an object) even if there is another object inside, the agent is holding something, and the microwave door is not explicitly mentioned to be open. 

  For example, In epoch_1, the agent was able to heat the mug with the microwave even though there was an egg inside the microwave and the agent was holding the mug.

- **rule_3 (type="Special Mechanism")**: The agent can only hold one object at a time and must put down any held object before taking another. 

  For example, In epoch_2, the agent was holding statue_4 and attempted to take statue_3 without putting down statue_4 first, resulting in a 'Nothing happens' observation.

- **rule_4 (type="Success Process")**: When tasked with placing multiple objects in/on a receptacle, the agent can either collect all objects before attempting to place them or find and place them one by one, ensuring they revisit locations with multiple objects if necessary. If all objects are found at the same location, handle them sequentially according to rule_3. 

  For example, In epoch_15, the agent should have revisited sidetable_1 to collect the second pencil before attempting to place it in coffeetable_1. In epoch_23, the agent failed to collect all required statues from coffeetable_1 because it did not revisit, is also addressed by this rule.

- **rule_5 (type="Special Mechanism")**: The agent must interact with a receptacle to observe its contents, which includes going to the receptacle and opening it if it is closed. Before performing a put or take action, the agent must ensure it is at the correct location. When multiple items of the same type are present at a location, the agent may have to choose one to interact with or examine.

  For example, In epoch_16, the agent had to open several closed cabinets (e.g., cabinet_1, cabinet_2) to find items such as the mug. In epoch_21, the agent observed multiple alarm clocks on desk_1 and selected one ('alarmclock_4') to interact with.


## Task-Specific Processes

### Introduction

This category outlines the steps required to complete specific tasks, such as heating, cooling, and examining objects with another object's assistance.

#### Included Rules

- **rule_6 (type="Success Process")**: If the task involves cooling or heating an object before placing it, the steps are: (1) search for the object using 'find_object' in rule_1, (2) take the object, (3) cool/heat it as required, (4) go to the target receptacle, and (5) put the object. Ensure the agent's location and the state of the environment are updated after each action. For example, 

  ```python
  # For example, to cool a mug and put it in a coffeemachine:
  # [Step 1] Use 'find_object' method to search all receptacles
  # [Step 2] Take the mug
  # [Step 3] Go to the fridge, open it if necessary, and cool the mug
  # [Step 4] Go to the coffeemachine and put the cooled mug in it
  ```
  
- **rule_7 (type="Success Process")**: When tasked with examining an object under a desklamp, the agent should first find the desklamp and the object, ensure the desklamp is on, take the object, and then use the desklamp to examine the object. For example, 

  ```python
  # [Step 1] Use 'find_object' method to search for the desklamp and the object
  # [Step 2] Make sure the desklamp is on
  # [Step 3] Take the object
  # [Step 4] Use the desklamp to examine the object.
  ```
  
- **rule_8 (type="Success Process")**: When tasked to look at an object under a desklamp, ensure the lamp is on before using it to examine the object. For example, 

  ```python
  # [Step 4] Go to the desklamp's location and turn it on if it's not already on
  observation = agent.go_to(receptacle_with_desklamp)
  observation = agent.use(found_desklamp)
  assert 'turn on' in observation or 'already on' in observation, 'Error in [Step 4]: Failed to use the desklamp.'
  # [Step 5] Similarly, search for the alarm clock and take it.
  # [Step 6] With the desklamp on, examine the alarm clock using the desklamp.
  ```

## Correctness and Validation

### Introduction

Instructions on asserting code to confirm state changes and enhance the reliability of the agent's actions.

#### Included Rules

- **rule_9 (type="Corrected Error")**: Assertions in the agent's code should confirm state changes such as location or held objects, rather than rely on specific phrases in observations. 

  For example, Instead of asserting 'You are at' in the observation, the agent should assert the location and held object state changes. Also, when handling multiple required objects at the same location, the agent should manage them sequentially without unnecessary variables.